<?php
/**
 * @copyright 2016-2020 Roman Parpalak
 * @license   MIT
 */

namespace S2\Rose\Entity;

class Indexable
{
    /**
     * @var ExternalId
     */
    protected $externalId;

    /**
     * @var string
     */
    protected $title = '';

    /**
     * @var string
     */
    protected $content = '';

    /**
     * @var string
     */
    protected $keywords = '';

    /**
     * @var string
     */
    protected $description = '';

    /**
     * @var \DateTime|null
     */
    protected $date;

    /**
     * @var string
     */
    protected $url = '';

    /**
     * @param string   $id
     * @param string   $title
     * @param string   $content
     * @param int|null $instanceId
     */
    public function __construct($id, $title, $content, $instanceId = null)
    {
        $this->externalId = new ExternalId($id, $instanceId);
        $this->title      = $title;
        $this->content    = $content;
    }

    /**
     * @return ExternalId
     */
    public function getExternalId()
    {
        return $this->externalId;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @param string $title
     *
     * @return Indexable
     */
    public function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * @return string
     */
    public function getContent()
    {
        return $this->content;
    }

    /**
     * @param string $content
     *
     * @return Indexable
     */
    public function setContent($content)
    {
        $this->content = $content;

        return $this;
    }

    /**
     * @return string
     */
    public function getKeywords()
    {
        return $this->keywords;
    }

    /**
     * @param string $keywords
     *
     * @return Indexable
     */
    public function setKeywords($keywords)
    {
        $this->keywords = $keywords;

        return $this;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param string $description
     *
     * @return Indexable
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * @return \DateTime|null
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @param \DateTime|null $date
     *
     * @return Indexable
     */
    public function setDate($date = null)
    {
        $this->date = $date;

        return $this;
    }

    /**
     * @return string
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * @param string $url
     *
     * @return Indexable
     */
    public function setUrl($url)
    {
        $this->url = $url;

        return $this;
    }

    /**
     * @return TocEntry
     */
    public function toTocEntry()
    {
        return new TocEntry($this->getTitle(), $this->getDescription(), $this->getUrl(), $this->calcHash(), $this->getDate());
    }

    /**
     * @return string
     */
    public function calcHash()
    {
        return md5(serialize([
            $this->getTitle(),
            $this->getDescription(),
            $this->getKeywords(),
            $this->getContent(),
        ]));
    }
}
